"Macro Data Sheet file v. 1" 
gamesystem GURPS 
title "GURPS Grimoire (v. 3.0.0)"

version 253
level 3

copyright "Copyright  1994, 1998, 2001 Steve Jackson Games Incorporated. All rights reserved. \
GURPS is a registered trademark of Steve Jackson Games Incorporated."

$$define PLUGIN G

$$include gurps.inc

logo GURPS/Grimoire.lgo


cat Disadvantages
	sublist "Physical Disadvantages" memlist
		$$ladv("Magic Susceptibility", -3/level, , "~x*-3", "x>0", "!Advantages:Magic Resistance")
		end
	end

cat Skills
	sublist Artistic memlist
		$$skill("Illusion Art", "MH", "Magical;Artistic", "iq-6;Artist-3")#dup
		end
	#sublist "Athletic" memlist
		##skill("Flight", "PA", "Athletic", "dx-4")
		# The Flight skill defaults to DX for naturally flying races.
		##skill("Flight (Natural)", "PA", "Athletic", "dx", , , "pa(~x,dx)-2")
			#varname "flight"
		#end
	sublist "Magical" memlist
		$$skill("Illusion Art", "MH", "Magical;Artistic", "iq-6;Artist-3")
		sublist "Spell Throwing" memlist
			$$skill("Spell Throwing (Silk)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			$$skill("Spell Throwing (proper)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			$$skill("Spell Throwing (Sunbolt)", PE, "Magical;Ranged;Spell Throwing", "dx-3;throwing;cat:'Spell Throwing'-2")
			end
		end
	end

cat Spells
# sp(name, class, resist, cat, time, dur, energy, prereq, page)
	
		# The following are "GMs may wish to..." prereq changes to the GURPSMagic.cds file

		##sp("Cure Disease", , , "Healing", "10 min.#", "Instant", "4#", "Resist Disease>=slc(12);Major Healing>=slc(12)", M50)
		##sp("Remove Curse", , "spell", "Meta-Spell", "1 hr.", "Instant", "20", "#1,Adv:Magery>=2~#1,15,Spells>=slc(12)|Suspend Curse>=slc(12)", M63)
		##sp("Drain Mana*", "Area", , "Meta-Spell", "1 hr.", "Perm.", "10", "Dispel Magic>=slc(12);#1,10,Sp;Suspend Mana>=slc(12)", M63)
		##sp("Lesser Geas*", , "IQ", "Mind Control", "30 sec.", "Perm.", "12", "#1,Adv:Magery>=2;Command>=slc(12);#10,Sp:Mind Control>=slc(12)", M68)
		##sp("Keen Ears", , , "Mind Control;*Keen", "1 sec.", "30 min.", "1 per +/h#", "Dull Ears>=slc(12)", M69)
		##sp("Keen Eyes", , , "Mind Control;*Keen", "1 sec.", "30 min.", "1 per +/h#", "Dull Eyes>=slc(12)", M69)
		##sp("Keen Nose", , , "Mind Control;*Keen", "1 sec.", "30 min.", "1 per +/h#", "Dull Nose>=slc(12)", M69)
		##sp("Wither Plant", "Area", "HT", "Plant", "10 sec.", "Perm.", "2", "Blight>=slc(12)", M76)
		##sp("Armor", , , "Protection and Warning", "1 sec.", "1 min.", "varies#", "Repair>=slc(12);Hardiness>=slc(12)", M76)
		##sp("Missile Shield", , , "Protection and Warning", "1 sec.", "1 min.", "5/2", "Deflect Missile>=slc(12)|Shield>=slc(12)", M77)
		

	sublist	"Animal" memlist
		$$sp("Beast Rouser", , , "Animal", , "1hr#", "1 to 3", "Adv:Animal Empathy|Vexation>=slc(12)", G9, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Protozoan Control", , "IQ", "Animal;*Animal Control", , , "1/1", "Beast-Soother>=slc(12)", G9, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Worm (lower Metazoan) Control", , "IQ", "Animal;*Animal Control", , , "2/1", "Beast-Soother>=slc(12)", G9, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Crustacean Control", , "IQ", "Animal;*Animal Control", , , "3/2", "Beast-Soother>=slc(12)", G9, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Arachnid Control", , "IQ", "Animal;*Animal Control", , , "3/2", "Beast-Soother>=slc(12)", G9, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Amphibian Control, , IQ, Animal;*Animal Control, , , 4/2, "Beast-Soother>=slc(12)", G9, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Hybrid Control, , IQ, Animal, , , 6/3, "#2,Sp:Animal Control>=slc(12)", G9, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Repel Fish, Area, HT, Animal, 10 sec., 1 hr., 3/2, "Fish Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Repel Insect, Area, HT, Animal, 10 sec., 1 hr., 3/2, "Insect Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Repel Mollusk, Area, HT, Animal, 10 sec., 1 hr., 3/2, "Mollusk Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Repel Bird, Area, HT, Animal, 10 sec., 1 hr., 4/2, "Bird Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Repel Reptile, Area, HT, Animal, 10 sec., 1 hr., 4/2, "Reptile Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp	Repel Mammal	Area	HT	Animal	10 sec.	1 hr.	5/3	Mammal Control>=slc(12)	G9	BeastKin?asp(~x,iq):hsp(~x,iq)
		$$sp(Repel Protozoan, Area, HT, Animal, 10 sec., 1 hr., 1/1, "Protozoan Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Repel Worm (lower Metazoan)", Area, HT, Animal, 10 sec., 1 hr., 2/1, "Worm (Lower Metazoan) Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Repel Crustacean, Area, HT, Animal, 10 sec., 1 hr., 3/2, "Crustacean Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Repel Arachnid, Area, HT, Animal, 10 sec., 1 hr., 3/2, "Arachnid Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp(Repel Amphibian, Area, HT, Animal, 10 sec., 1 hr., 4/2, "Amphibian Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp	Repel Hybrids*	Area	HT	Animal	10 sec.	1 hr.	6/3	Hybrid Control>=slc(12)	G10	BeastKin?hsp(~x,iq):vhsp(~x,iq)

		$$sp	Permanent Beast Possession*		IQ	Animal	1 min.	Indef.	20	"#1,Adv:Magery>=2;Beast Possession>=slc(12)"	G10	BeastKin?hsp(~x,iq):vhsp(~x,iq)
		$$sp(Spider Silk, Special;Missile, , Animal, , , "1/5 hexes#", "#1,Adv:Magery>=1;Arachnid Control>=slc(12)", G10, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		sublist "Partial Shapeshifting" memlist
			$$sp(Partial Shapeshifting*, , IQ, Animal, 10 sec., 1 hr., varies, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Chameleon Eyes*, , IQ, Animal, 10 sec., 1 hr., 3/1, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Crocodile Jaws*, , IQ, Animal, 10 sec., 1 hr., 5/2, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Elephant Trunk*, , IQ, Animal, 10 sec., 1 hr., 3/1, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Feathered Arms*, , IQ, Animal, 10 sec., 1 hr., 3/1, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Fish Tail*, , IQ, Animal, 10 sec., 1 hr., 3/1, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Mountain Goat Hooves*, , IQ, Animal, 10 sec., 1 hr., 4/2, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Saber-Teeth*, , IQ, Animal, 10 sec., 1 hr., 5/2, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Scorpion Tail*, , IQ, Animal, 10 sec., 1 hr., 7/3, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Serpent's Fangs*, , IQ, Animal, 10 sec., 1 hr., 3/1, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Skunk Tail*, , IQ, Animal, 10 sec., 1 hr., 3/1, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Spider Arms*, , IQ, Animal, 10 sec., 1 hr., 7/3, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Tiger Paws*, , IQ, Animal, 10 sec., 1 hr., 4/2, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Toad Tongue*, , IQ, Animal, 10 sec., 1 hr., 3/1, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp(Turtle Shell*, , IQ, Animal, 10 sec., 1 hr., 10/4, "#1,Adv:Magery>=3;#1,Sp:*Shapeshift Others>=slc(12);Alter Body>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			end
		sublist "Permanent Shapeshifting" memlist
			$$sp(Permanent Shapeshifting*, , , Animal, 1 min., Indef., 5x Shapeshifting, "#1,Adv:Magery>=3;#1,Sp:*Shapeshifting>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Permanent Shapeshifting (Wolf)*", , , Animal, 1 min., Indef., 30, "#1,Adv:Magery>=3;Shapeshifting (Wolf)>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Permanent Shapeshifting (Bear)*", , , Animal, 1 min., Indef., 30, "#1,Adv:Magery>=3;Shapeshifting (Bear)>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Permanent Shapeshifting (Boar)*", , , Animal, 1 min., Indef., 30, "#1,Adv:Magery>=3;Shapeshifting (Boar)>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Permanent Shapeshifting (Giant Eagle)*", , , Animal, 1 min., Indef., 30, "#1,Adv:Magery>=3;Shapeshifting (Giant Eagle)>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Permanent Shapeshifting (Tiger)*", , , Animal, 1 min., Indef., 30, "#1,Adv:Magery>=3;Shapeshifting (Tiger)>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			$$sp("Permanent Shapeshifting (Giant Snake)*", , , Animal, 1 min., Indef., 30, "#1,Adv:Magery>=3;Shapeshifting (Giant Snake)>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
			end
		$$sp(Merging Shapeshifting*, Special, IQ, Animal, 30 sec., 1 hr., 8/3, "#1,Adv:Magery>=3;#2,Sp:*Shapeshift Others>=slc(12);#2,Sp:Animal Control>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
		$$sp(Great Shapeshifting*, Special, , Animal, 5 sec., , 8/4, "#1,Adv:Magery>=3;Alter Body>=slc(12);#4,Sp:*Shapeshifting>=slc(12);#10,Spells>=slc(12)", G12, "BeastKin?hsp(~x,iq):vhsp(~x,iq)")
		end
	sublist "Body Control" memlist
		$$sp(Touch, , , Body Control, , Instant, 1, , G13)
		$$sp(Boost Strength, Regular;Blocking, , Body Control, none, Instant, 1 to 5, "Might>=slc(12)", G13)
		$$sp(Boost Dexterity, Regular;Blocking, , Body Control, none, Instant, 1 to 5, "Dexterity>=slc(12)", G13)
		$$sp(Boost Health, Regular;Blocking, , Body Control, none, Instant, 1 to 5, "Vigor>=slc(12)", G13)
		$$sp(Frailty, , HT, Body Control, , , "2 per -/s#", "Lend Strength>=slc(12)", G14)
		$$sp(Hold Breath, , , Body Control, , , 4/2, "#1,Adv:Magery>=1;Vigor>=slc(12)", G14)
		$$sp(Perfume, , HT, Body Control, , 10 min., 2/1, "Itch>=slc(12)|Odor>=slc(12)", G14)
		$$sp(Strike Barren, , HT, Body Control;Necromantic, 30 sec., Perm., 5, "#1,Adv:Magery>=1;Steal Health>=slc(12);Decay>=slc(12)", G14)
		$$sp(Strike Anosmic, , HT, Body Control, , 10 sec., 2/1, "Spasm>=slc(12)", G14)
		$$sp(Strike Numb, , HT, Body Control, , 10 sec., 3/1, "Resist Pain>=slc(12)", G14)
		$$sp(Control Limb, , IQ, Body Control, , 5 sec., "3/3#", "#1,Adv:Magery>=1;#5,Sp:Body Control>=slc(12);Spasm>=slc(12)", G14)
		$$sp(Tickle, , IQ, Body Control, , 1 sec., 2/2, "Itch>=slc(12)", G15)
		$$sp(Hunger, , HT, "Body Control;Food", 5 sec., "1 day#", 2, "#1,Adv:Magery>=1;Fatigue>=slc(12);Decay>=slc(12)", G15)
		$$sp(Thirst, , HT, "Body Control;Food", 10 sec., "1 day#", 5, "#1,Adv:Magery>=1;Fatigue>=slc(12);Destroy Water>=slc(12)", G15)
		$$sp(Retch, , HT, Body Control, 4 sec., varies, 3, "#3,Sp:Body Control>=slc(12);Spasm>=slc(12)", G15)
		$$sp(Stop Spasm, , , Body Control;Healing, , , 1, "Spasm>=slc(12)|Lend Health>=slc(12)", G15)
		$$sp(Choke, , HT, Body Control, , 10 sec., 4/4, "#1,Adv:Magery>=1;#5,Sp:Body Control>=slc(12);Spasm>=slc(12)", G15)
		$$sp(Balance, , , Body Control, , , 5/3, "Boost Dexterity>=slc(12)", G16)
		$$sp(Reflexes, , , Body Control, , , 5/3, "Dexterity>=slc(12);Haste>=slc(12)", G16)
		$$sp(Ambidexterity, , , Body Control, , , 3/2, "Dexterity>=slc(12)", G16)
		$$sp(Fumble, Blocking, DX, Body Control, none, Instant, 5, "Clumsiness>=slc(12)", G16)
		$$sp(Cadence, , , Body Control, 10 sec., 1 hr., 5/3, "Haste>=slc(12);Dexterity>=slc(12)", C16)
		$$sp(Weaken Blood, , HT, Body Control, , 1 day, 9/5, "Sickness>=slc(12)|Steal Health>=slc(12)", G16)
		$$sp(Haircut, , HT, Body Control, 2 sec., Instant, 2, "Weaken>=slc(12);#2,Sp:Body Control>=slc(12)", G16)
		$$sp(Hair Growth, , HT, Body Control, , 5 sec., 1/1, "#5,Sp:Body Control>=slc(12)", G17)
		$$sp(Corpulence*, , HT, Body Control, 3 sec., 10 min., 6/6, "#1,Adv:Magery>=2;Create Earth>=slc(12);Create Water>=slc(12);#4,Sp:Body Control>=slc(12);Alter Body>=slc(12)", G17)
		$$sp(Gauntness*, , HT, Body Control, 3 sec., 10 min., 6/6, "#1,Adv:Magery>=2;Earth to Air>=slc(12);Destroy Water>=slc(12);#4,Sp:Body Control>=slc(12);Hunger>=slc(12)", G17)
		$$sp(Decapitation*, , HT+2, Body Control, 2 sec., Perm., 6, "#1,Adv:Magery>=2;Alter Body>=slc(12)", G17)
		$$sp(Sensitize, , HT, Body Control, , , 3/2, "#1,Adv:Magery>=1;Stun>=slc(12)", G17)
		$$sp(Agonize, , HT, Body Control, , , 8, "#1,Adv:Magery>=2;Sensitize>=slc(12)", G18)
		$$sp(Alter Voice, , HT, Body Control;Sound, 30 sec., 1 hr., 3/2, "#4,Sp:Body Control>=slc(12);#4,Sp:Sound>=slc(12)", G18)
		$$sp(Lengthen Limb, , , Body Control, 5 sec., 1 min., 2/2, "#1,Adv:Magery>=3;#1,Sp:Shapeshifting>=slc(12)", G18)
		$$sp("Shrink*", , , "Body Control;*Shifting", "5 sec.", "1 hr.", "varies#", "#1,Adv:Magery>=2;Alter Body>=slc(12)", G18)
		$$sp(Shrink Other*, , HT, Body Control, 10 sec., 1 hr., varies, "#1,Adv:Magery>=3;Shrink>=slc(12)", G19)
		$$sp("Enlarge*", , , "Body Control;*Shifting", "5 sec.", "1 hr.", "varies#", "#1,Adv:Magery>=2;Alter Body>=slc(12)", G19)
		$$sp(Enlarge Other*, , HT, Body Control, 10 sec., 1 hr., varies, "#1,Adv:Magery>=3", G19)
		end
	sublist "Communication and Empathy" memlist
		$$sp("Hide Emotion", , , "Communication and Empathy", , 1 hr., 2/1, "Sense Emotion>=slc(12)", G20)
		$$sp(Vexation, , IQ, "Communication and Empathy", , , 2 to 10/2 to 10, "Sense Emotion>=slc(12)", G20)
		$$sp(Insignificance, , Presence, "Communication and Empathy", 10 sec., 1 hr., 4/4, "Persuasion>=slc(12);Avoid>=slc(12)", G20)
		$$sp(Presence, , Insignificance, "Communication and Empathy", 10 sec., 1 hr., 4/4, "Persuasion>=slc(12);Lure>=slc(12)", G20)
		$$sp(Communication*, , , "Communication and Empathy", 4 sec., , 4/4, "Wizard Eye>=slc(12);Far-Hearing>=slc(12);Voices>=slc(12);Simple Illusion>=slc(12)", G20)
		$$sp("Dream Viewing", , IQ, "Communication and Empathy", 10 sec., 1 hr., 2/1, "Truthsayer>=slc(12);Sleep>=slc(12)", G21)
		$$sp("Dream Sending", , IQ, "Communication and Empathy", 1 min., 1 hr., 3, "Dream Viewing>=slc(12)", G21)
		$$sp("Dream Projection", , , "Communication and Empathy", 1 min., 1 min., 3/3, "Dream Sending>=slc(12)", G21)
		$$sp(Retrogression, , IQ, "Communication and Empathy", 10 sec., 1 sec., 5, "Mind-Search>=slc(12);Mind-Sending>=slc(12)", G21)
		$$seespell	Compel Lie	Mind Control
		$$seespell	Machine Speech	Technological
		end
	sublist "Earth" memlist
		$$sp("Rain of Stones", Area, , Earth, , , 1/1, "#1,Adv:Magery>=2;Create Earth>=slc(12)", G22)
		$$sp("Mud Jet", , , "Earth;Water", , 1 sec., 1 to 3, "Water Jet>=slc(12);Create Earth>=slc(12)", G22)
		$$sp("Partial Petrification*", , HT, Earth, 3 sec., Perm., 12, "#1,Adv:Magery>=2;Flesh to Stone>=slc(12)", G22)
		$$sp(Steelwraith, , HT, Earth, 2 sec., , 7/4, "#1,Adv:Magery>=2;Walk Through Earth>=slc(12)", G22)
		$$sp("Essential Earth", , , Earth, 30 sec., Perm., 8 per hex, "#6,Sp:Earth>=slc(12)", G22)
		$$sp("Alter Terrain*", Area, , Earth, 10 sec., 2d days, 1, "Shape Earth>=slc(12);Shape Air>=slc(12);Shape Fire>=slc(12);Shape Water>=slc(12);Shape Stone>=slc(12)", G23)
		$$sp("Move Terrain*", Area, Special, Earth, 1 min., 1 hr., 10/8, "Alter Terrain>=slc(12);Hide Object>=slc(12)", G23)
		$$sp("Purify Earth", Area, , "Earth;Plant", 30 sec., Perm., 2, "Shape Earth>=slc(12);Apportation>=slc(12)", G24, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Earth to Water", , , "Earth;Water;*Transmutation", "1 sec.", "Perm.", "varies#", "#1,Adv:Magery>=1;Create Water>=slc(12);Shape Earth>=slc(12)", G24)
		$$seespell	Sandstorm	Air
		end
	sublist "Air" memlist
		$$sp("Seek Air", "Information", , "Air;*Seek", , Instant, 1, , G24)
		$$sp("Air Vision", , , Air, , , 1 per mile/h, "Shape Air>=slc(12)", G24)
		$$sp(Concussion, Missile, , "Air;Sound", 1 to 3 sec., Instant, 2 to 6, "Shape Air>=slc(12);Thunderclap>=slc(12)", G24)
		$$sp("Devitalize Air", Area, , Air, , varies, 2, "Destroy Air>=slc(12)", G24)
		$$sp("Wall of Wind", Area, , Air, 1 sec./hex, , 2/1, "Shape Air>=slc(12)", G25)
		$$sp(Sandstorm, Area, , "Earth;Air", 1 sec./hex, , 3/1.5, "Windstorm>=slc(12);Create Earth>=slc(12)", G25)
		$$sp("Air Vortex", Area, HT or DX, "Air;Movement", 2 sec., 10 sec., 8/3, "#1,Adv:Magery>=2;Body of Air>=slc(12);Whirlwind>=slc(12)", G25)
		$$sp("Body of Wind", , HT, Air, 2 sec., , 8/4, "#1,Adv:Magery>=3;Body of Air>=slc(12);Windstorm>=slc(12);#1,5,Spells>=slc(12)", G25)
		$$sp("Essential Air", Area, , Air, 3 sec., Permanent, 2, "#6,Sp:Air>=slc(12)", G26)
		sublist Weather memlist
			$$sp(Wind, Special;Area, , "Air;*Weather", 1 min., 1 hr., 1/50/s, "#4,Sp:Water>=slc(12);#4,Sp:Air>=slc(12)", G26)
			$$sp(Storm, Area, , "Air;Water;*Weather", 1 min., 1 hr., 1/50/s, "Rain>=slc(12);Hail>=slc(12)", G26)
			$$sp(Warm, Area, , "Air;*Weather", 1 min. per cost, 1 hr., 1/10/s, "Heat>=slc(12);#6,Sp:Air>=slc(12)", G27)
			$$sp(Cool, Area, , "Air;*Weather", 1 min. per cost, 1 hr., 1/10/s, "Cold>=slc(12);#6,Sp:Air>=slc(12)", G27)
			$$seespell	Cloud-Walking	Movement, Air, Water
			$$seespell	Cloud-Vaulting*	Movement, Air, Water
			end
		sublist Electricity memlist
			$$sp("Resist Lightning", , , "Air;Protection and Warning;*Electricity", , , 2/1, "#6,Sp:Air>=slc(12)", G27)
			$$sp("Shocking Touch", , , "Air;*Electricity", , Instant, 1 to 3, "Lightning>=slc(12)", G27)
			$$sp("Electric Weapon", , , "Air;*Electricity", 2 sec., , 4/1, "#1,Adv:Magery>=2;Lightning>=slc(12)", G27)
			$$sp("Electric Missiles", , , "Air;*Electricity", 3 sec., , 4/2, "Electric Weapon>=slc(12)", G27)
			$$sp("Lightning Stare*", , , "Air;*Electricity", 2 sec., 1 sec., 1 to 4, "#1,Adv:Magery>=1;Lightning>=slc(12);Resist Lightning>=slc(12)", G28)
			$$sp("Lightning Whip", , , "Air;*Electricity", 2 sec., 10 sec., 1 per 2 hexes/same, "#1,Adv:Magery>=1;Lightning>=slc(12)", G28)
			$$sp("Ball of Lightning", , , "Air;*Electricity", 1 to 3 sec., , 2 to 6/1 to 3, "Apportation>=slc(12);Lightning>=slc(12)", G28)
			$$sp("Wall of Lightning", Area, , "Air;*Electricity", , , 2 to 6/2 to 6, "#1,Adv:Magery>=1;Lightning>=slc(12)", G28)
			$$sp("Electric Armor", , , "Air;*Electricity", , , 7/4, "#1,Adv:Magery>=1;Lightning>=slc(12);Resist Lightning>=slc(12)", G28)
			$$sp("Body of Lightning*", , HT, "Air;*Electricity", 5 sec., , 12/4, "#1,Adv:Magery>=2;Lightning>=slc(12)", G29)
			$$sp("Spark Cloud", Area, , "Air;*Electricity", 1 to 5 sec., 10 sec., 1 to 5/1 to 5, "Shape Air>=slc(12);Lightning>=slc(12)", G29)
			$$sp("Spark Storm", Area, , "Air;*Electricity", 1 sec./hex radius, , 2 to 6/1 to 3, "Windstorm>=slc(12);Lightning>=slc(12)", G29)
			end
		end
	sublist "Fire" memlist
		$$sp("Seek Fire", Information, , "Fire;*Seek", , Instant, 1, , G29)
		$$sp("Slow Fire", , , Fire, , , varies, "Extinguish Fire>=slc(12)", G29)
		$$sp("Fast Fire", , , Fire, , , varies, "Slow Fire>=slc(12)", G29)
		$$sp(Flameturning, Blocking, , Fire, , Instant, 2, "Resist Fire>=slc(12)|Apportation>=slc(12);Shape Fire>=slc(12)", G30)
		$$sp(Warmth, , , Fire, 10 sec., 1 hr., 2/1, "Heat>=slc(12)", G30)
		$$sp(Smoke, Area, , Fire, , 5 min. or less, 1, "Shape Fire>=slc(12);Extinguish Fire>=slc(12)", G30)
		$$sp("Burning Touch", , , Fire, , Instant, 1 to 3, "#1,Adv:Magery>=2;#6,Sp:Fire>=slc(12);Heat>=slc(12)", G30)
		$$sp("Rain of Fire", Area, , Fire, , , 1/1, "#1,Adv:Magery>=2;Create Fire>=slc(12)", G30)
		$$sp("Fire Cloud", Area, , Fire, 1 to 5 sec., 10 sec., 1 to 5, "Shape Air>=slc(12);Fireball>=slc(12)", G30)
		$$sp("Flaming Armor", , , Fire, , , 6/3, "#1,Adv:Magery>=1;Resist Fire>=slc(12);Flame Jet>=slc(12)", G31)
		$$sp("Body of Flames*", , HT, Fire, 5 sec., , 12/4, "Breathe Fire>=slc(12)", G31)
		$$sp("Burning Death*", , HT, "Fire;Necromantic", 3 sec., 1 sec., 3/2, "#1,Adv:Magery>=2;Heat>=slc(12);Sickness>=slc(12)", G31)
		end
	sublist "Water" memlist
		$$sp("Dry Well", , , Water, 1 min., Permanent, 3 for each gal./min., "Destroy Water>=slc(12);Shape Earth>=slc(12)", G32)
		$$sp("Create Well", , , Water, 1 min., Permanent, 5 for each gal./min., "Dry Well>=slc(12);Shape Water>=slc(12)", G32)
		$$sp("Foul Water", Area, , "Water;Food", , Permanent, 3, "Purify Water>=slc(12);Decay>=slc(12)", G32)
		$$sp("Walk Through Water", , , Water, 3 sec., 1 sec., "4/3 (8/6 for pressure)", "#1,Adv:Magery>=1;Shape Water>=slc(12)", G32)
		$$sp("Resist Water", , , "Water;Protection and Warning", , , 2/1, "Umbrella>=slc(12)|Shape Water>=slc(12);Destroy Water>=slc(12)", G33)
		$$sp(Whirlpool, Area, , Water, 1 sec./hex, , 2/1, "Shape Water>=slc(12)", G33)
		$$sp("Boil Water", , , Water, 10 sec., Permanent, 1 to 6+, "Shape Water>=slc(12);Heat>=slc(12)", G33)
		$$sp("Condense Steam", Area, , Water, 10 sec., Permanent, 1, "Cold>=slc(12)|Boil Water>=slc(12)", G33)
		$$sp("Create Steam", "Area", , "Water;*Create", 1 sec., "5 min.#", "2", "Boil Water>=slc(12)", G33)
		$$sp("Steam Jet", , , Water, , 1 sec., 1 to 3/1 to 3, "Water Jet>=slc(12);Boil Water>=slc(12)", G34)
		$$sp("Breathe Steam*", , , Water, 2 sec., 1 sec., 1 to 4, "#1,Adv:Magery>=1;Steam Jet>=slc(12);Resist Fire>=slc(12)", G34)
		sublist "Weather" memlist
			$$sp(Current, Special;Area, , Water;Weather, 1 min., 1 hr., 1/50/s, "#8,Sp:Water>=slc(12)", G34)
			$$sp(Waves, Special;Area, , Water;Weather, 1 min., 1 hr., 1/60/s, "Shape Water>=slc(12)", G34)
			$$sp(Tide, Special;Area, , Water;Weather, 1 min., 1 hr., 1/30/s, "#8,Sp:Water>=slc(12)", G34)
			end
		sublist "Ice" memlist
			$$sp(Coolness, , , "Water;Ice;Protection and Warning", 10 sec., 1 hr., 2/1, "Cold>=slc(12)", G35)
			$$sp("Create Ice", , , "Water;Ice;*Create", , "Perm.#", "2 per gal.", "Freeze>=slc(12)", G35)
			$$sp("Snow Jet", , , "Water;Ice", , 1 sec., 1 to 3, "Water Jet>=slc(12);Freeze>=slc(12)", G35)
			$$sp("Icy Touch", , , "Water;Ice", , Permanent, 2 per 1/4 in., "#1,Adv:Magery>=1;#4,Sp:Ice>=slc(12)", G35)
			$$sp("Flesh to Ice*", , "HT", "Water;Ice;*Transmutation", "2 sec.", "Perm.#", "12", "#1,Adv:Magery>=1;Frostbite>=slc(12);Body of Water>=slc(12)", G35)
			$$sp("Body of Ice*", , HT, "Water;Ice", 5 sec., , 7/3, "#1,Adv:Magery>=2;Body of Water>=slc(12);Freeze>=slc(12)", G36)
			$$sp("Icy Breath*", , , "Water;Ice", 2 sec., 1 sec., 1 to 4, "#1,Adv:Magery>=1;Snow Jet>=slc(12);Resist Cold>=slc(12)", G36)
			$$sp("Icy Missiles", , , "Water;Ice", 3 sec., , 4/2, "Icy Weapon>=slc(12)", G36)
			$$sp("Rain of Ice Daggers", Area, , "Water;Ice", , , "2/2#", "#1,Adv:Magery>=2;Hail>=slc(12);Ice Dagger>=slc(12)", G36)
			end
		sublist "Acid" memlist
			$$sp("Create Acid", , , "Water;Acid;*Create", "2 sec.", "Perm.#", "4 per gal.#", "#1,Adv:Magery>=1;Create Water>=slc(12);Create Earth>=slc(12)", G37)
			$$sp("Resist Acid", , , "Water;Acid;Protection and Warning", , , 2 or 6/h, "Purify Water>=slc(12);Create Acid>=slc(12)", G37)
			$$sp("Acid Jet", , , "Water;Acid", , 1 sec., 1 to 3, "#1,Adv:Magery>=2;Water Jet>=slc(12);Create Acid>=slc(12)", G37)
			$$sp("Spit Acid*", , , "Water;Acid", 2 sec., 1 sec., 1 to 4, "#1,Adv:Magery>=3;Acid Jet>=slc(12);Resist Acid>=slc(12)", G37)
			$$sp("Acid Ball", Missile, , "Water;Acid", 1 to 3 sec., , 1 to 3, "#1,Adv:Magery>=2;Create Acid>=slc(12)", G37)
			$$sp("Rain of Acid", Area, , "Water;Acid", , , 3/3, "#1,Adv:Magery>=2;Create Water>=slc(12);Create Earth>=slc(12)", G37)
			$$sp("Essential Acid", , , "Water;Acid", , "Perm.#", 8 per gal., "#6,Sp:Acid>=slc(12)", G37)
			end
		end
	sublist "Enchantment" memlist
		$$sp(Talisman, "Enchantment;*Talisman", , Enchantment, , Perm., "varies#", "Enchant>=slc(12)", G38)
		$$sp(Amulet, Enchantment, , Enchantment, , Perm., 50/pt. of Magic Resistance, , G38)
		$$sp("Spell Stone", Enchantment, , Enchantment, , varies, 20x spell cost, "Enchant>=slc(12);Delay>=slc(12)", G39)
		$$sp(Malefice*, Enchantment, Special, Enchantment, , "Indef.#", 250, "Enchant>=slc(12);Seeker>=slc(12)", G39)
		$$sp(Ensorcel*, Enchantment, Special, Enchantment, , "Perm.#", 200x spell cost, "Malefice>=slc(12)", G39)
		$$sp(Simulacrum, Enchantment, , Enchantment, , Perm., 2x golem, "#1,Adv:Magery>=3;Golem>=slc(12);Perfect Illusion>=slc(12);Illusion Disguise>=slc(12)", G39)
		$$sp(Doppelganger*, Enchantment, , Enchantment, , Perm., 1000, "#1,Adv:Magery>=3;Golem>=slc(12);History>=slc(12);Enslave>=slc(12)", G40)
		$$sp(Leak, Enchantment, , Enchantment, , Perm., 100, "Hideaway>=slc(12)", G40)
		
		sublist "Armor Enchantments" memlist
			$$sp("Defending Shield", Enchantment, , Enchantment, , Perm., varies, "Enchant>=slc(12);Dexterity>=slc(12)", G40)
			$$sp("Dancing Shield", Enchantment, , Enchantment, , Perm., varies, "Enchant>=slc(12);Air-Golem>=slc(12)", G40)
			end
		sublist "Weapon Enchantments" memlist
			$$sp("Defending Weapon", Enchantment, , "Enchantment;*Weapon Enchantment", , Perm., varies, "Enchant>=slc(12);Air-Golem>=slc(12)", G40)
			$$sp("Penetrating Blade", Enchantment, , "Enchantment;*Weapon Enchantment", , Perm., varies, "Enchant>=slc(12);Find Weakness>=slc(12)", G41)
			$$sp("Ghost Weapon", Enchantment, , "Enchantment;*Weapon Enchantment", , Perm., 250/lb., "Enchant>=slc(12);Solidify>=slc(12)", G41)
			$$sp("Quick-Aim", Enchantment, , "Enchantment;*Weapon Enchantment", , Perm., varies, "Enchant>=slc(12);Dexterity>=slc(12)", G41)
			$$sp("Graceful Weapon", Enchantment, , "Enchantment;*Weapon Enchantment", , Perm., 150/lb., "Enchant>=slc(12);Apportation>=slc(12)", G41)
			$$sp("Weapon Spirit*", Enchantment, , "Enchantment;*Weapon Enchantment", , Perm., varies, "Enchant>=slc(12);Summon Spirit>=slc(12)", G41)
			end
		sublist "Wizardly Tools" memlist
			$$sp(Effigy*, Enchantment, , Enchantment, , Perm., 1000, "Enchant>=slc(12);Scryfool>=slc(12);Ward>=slc(12)", G42)
			$$sp(Homunculus, Enchantment, , Enchantment, , Perm., 800, "Enchant>=slc(12);Mind-Sending>=slc(12)", G42)
			$$sp(Manastone*, Enchantment, , Enchantment, , Perm., 5, "Enchant>=slc(12)", G42)
			$$sp("One-College Powerstone", Enchantment, , Enchantment, , Perm., 12, "Enchant>=slc(12)", G44)
			$$sp("Soul Stone*", Enchantment, , Enchantment, , Perm., 500, "#1,Adv:Magery>=3;Enchant>=slc(12);Soul Jar>=slc(12)", G42)
			$$sp("Soul Golem*", Enchantment, , Enchantment, , Perm., 1000, "#1,Adv:Magery>=3;Soul Jar>=slc(12);Golem>=slc(12)", G42)
			end
		end
	sublist Food memlist
		$$sp(Season, , Special, Food, 10 sec., Perm., 2 per meal, "Test Food>=slc(12)", G43)
		$$sp("Prepare Game", , , Food, 10 sec., Perm., 2, "Purify Food>=slc(12)", G43)
		$$sp("Know Recipe/TL", Information, Special, "Food;Knowledge;Technological;*Machine;*Energy;*Radiation;*Metal/Plastic", 10 sec., Instant, 3, "Seek Food>=slc(12);History>=slc(12)", G43)
		$$sp("Far-Tasting", , , Food, 3 sec., , 3/1, "#1,Adv:Magery>=1;Seek Food>=slc(12)|Seek Air>=slc(12);!Disad:Anosmia", G43)
		$$sp("Essential Food*", , , Food, 30 sec., Perm., "3/meal#", "#1,Adv:Magery>=2;Banquet>=slc(12);Create Food>=slc(12)", G43)
		$$seespell	Cure Dehydration	Healing
		$$seespell	Cure Starvation	Healing
		$$seespell	Foul Water	Water
		$$seespell	Hunger	Body Control
		$$seespell	Scents of the Past	Knowledge
		$$seespell	Thirst	Body Control
		$$seespell	Wizard Mouth	Knowledge, Sound
		$$seespell	Wizard Nose	Knowledge
		end
	sublist "Gate" memlist
		$$sp("Beacon", "Area", , "Gate;Movement", "30 sec.", "24 hrs.", "10/h#", "Teleport>=slc(12)|Timeport>=slc(12)|Plane Shift>=slc(12)", G44)
		$$sp("Hide Object", , , "Gate", "10 sec.", "1 hr.", "1 per lb./s", "Hideaway>=slc(12);Teleport>=slc(12)", G44)
		$$sp("Sanctuary*", "Special", , "Gate", "10 sec.", "1 hr.", "5/5", "Hide Object>=slc(12)", G45)
		$$sp("Planar Visit*", "Special", , "Gate", "30 sec.", "1 min.", "4/2#", "#1,Adv:Magery>=2~Projection>=slc(12)|Planar Summons>=slc(12)", G45)
		$$sp("Plane Shift*", "Special", , "Gate", "5 sec.", "Perm.", "20#", "Planar Summons>=slc(12)", G46)
		$$sp("Plane Shift Other*", , "IQ+1", "Gate", "5 sec.", "Perm.", "20#", "#1,Adv:Magery>=3;Plane Shift>=slc(12)", G46)
		$$sp("Phase", "Blocking", , "Gate", "none", "Instant", "3", "#1,Adv:Magery>=3~Plane Shift>=slc(12)|Ethereal Body>=slc(12)", G46)
		$$sp("Phase Other*", "Blocking", , "Gate", "none", "Instant", "3", "Phase>=slc(12)", G46)
		$$sp("Timeport*", "Special", , "Gate", , "Instant", "varies#", "#1,Adv:Magery>=3;Teleport>=slc(12)", G46)
		$$sp("Timeport Other*", , "IQ+1", "Gate", , "Instant", "varies#", "Timeport>=slc(12)", G47)
		$$sp("Timeslip", "Blocking", , "Gate", "none", "Instant", "1 per sec.#", "Timeport>=slc(12)", G47)
		$$sp("Timeslip Other*", "Blocking", , "Gate", "none", "Instant", "1 per sec.#", "Timeslip>=slc(12)", G47)
		$$sp("Trace Teleport", "Information", "Spell", "Gate;Movement", , "Instant", "3", "Teleport>=slc(12)|Timeport>=slc(12)|Plane Shift>=slc(12)", G47)
		$$sp("Rapid Journey*", "Special", , "Gate;Movement", "5 sec.", "1 min.", "varies#", "#1,Adv:Magery>=3~Teleport>=slc(12)|Timeport>=slc(12)", G48)
		$$sp("Divert Teleport*", "Blocking", "spell", "Gate;Movement", "none", "Instant", "varies*", "#1,Adv:Magery>=3;Trace Teleport>=slc(12)", G48)
		$$sp("Create Door", , , "Gate", "5 sec.", "10 sec.", "2 per hex/s", "Teleport>=slc(12)~Walk Through Earth>=slc(12)|Walk Through Plants>=slc(12)|Walk Through Water>=slc(12)|Walk Through Wood>=slc(12)", G48)
		$$sp("Seek Gate", "Information", , "Gate;*Seek", "10 sec.", "Instant", "3", "#1,Adv:Magery>=2;Seek Magic>=slc(12);#1,10,Spells>=slc(12)", G49)
		$$sp("Scry Gate", , , "Gate", "10 sec.", , "4/4", "Seek Gate>=slc(12)", G49)
		$$sp("Control Gate", , "gate", "Gate", "10 sec.", , "6/3", "#1,Adv:Magery>=3;Seek Gate>=slc(12)", G49)
		$$sp("Create Gate*", , , "Gate", "sec.=cost", , "varies#", "Control Gate>=slc(12)~Teleport>=slc(12)|Timeport>=slc(12)|Plane Shift>=slc(12)", G49)
		$$sp("Slow Time*", "Area", "Special", "Gate", "2 sec.", "1 min.#", "varies#", "#1,Adv:Magery>=2;Main:IQ>=15;#2,10,Spells>=slc(12)", G50)
		$$sp("Accelerate Time*", "Area", "Special", "Gate", "2 sec.", "1 min.#", "varies#", "#1,Adv:Magery>=2;Main:IQ>=15;#2,10,Spells>=slc(12)", G50)
		$$sp("Suspend Time*", "Area", "Special", "Gate", "5 min.", "1 day#", "5/5", "#1,Adv:Magery>=3;Slow Time>=slc(12)", G50)
		$$sp("Time Out*", "Area", , "Gate", "5 min.", "Instant#", "5", "#1,Adv:Magery>=3;Accelerate Time>=slc(12)", G51)
		$$seespell	Blink Other*	Movement
		$$seespell	Summon Minor Demons	Necromantic
		end
	sublist "Healing" memlist
		$$sp("Body-Reading", "Information", "IQ", "Healing", "30 sec.", "Instant", "2", "Sense Life>=slc(12)|Awaken>=slc(12)", G51)
		$$sp("Share Health", , , "Healing", "sec.=HP", "Perm.", "none", "Lend Health>=slc(12)", G51)
		$$sp("Cleansing", , "Special", "Healing", "3 sec.", "Perm.", "varies#", "Minor Healing>=slc(12);Shatter>=slc(12);Sterilize>=slc(12)", G52)
		$$sp("Healing Slumber", , "Automatic", "Healing", "30 sec.", "8 hrs.#", "6#", "#1,Adv:Magery>=2;Peaceful Sleep>=slc(12);Minor Healing>=slc(12)", G52)
		$$sp("Cure Starvation", , , "Healing;Food", "10 sec.", "Perm.", "2 per Fatigue#", "#1,Adv:Magery>=1;Minor Healing>=slc(12);Create Food>=slc(12)", G52)
		$$sp("Cure Dehydration", , , "Healing;Food", "10 sec.", "Perm.", "2 per Fatigue#", "#1,Adv:Magery>=1;Minor Healing>=slc(12);Create Water>=slc(12)", G52)
		$$sp("Instant Neutralize Poison*", , , "Healing", "1 sec.", "Instant", "8", "#1,Adv:Magery>=2;Neutralize Poison>=slc(12)", G52)
		$$sp("Restore Memory", , , "Healing", "10 sec.", "Perm.", "3", "Awaken>=slc(12);Main:IQ>=12", G53)
		$$sp("Stop Bleeding", , , "Healing", , "Perm.#", "1#", "Lend Health>=slc(12)", G53)
		$$sp("Stop Paralysis", , , "Healing", , "Perm.", "1#", "Major Healing>=slc(12)|Minor Healing>=slc(12);Paralyze Limb>=slc(12)", G53)
		$$sp("Relieve Paralysis", , , "Healing;*Restore", "10 sec.", "1 min.", "varies#", "Stop Paralysis>=slc(12)", G53)
		$$sp("Relieve Sickness", , , "Healing", "10 sec.", "10 min.", "2", "Lend Health>=slc(12)", G54)
		$$sp("Relieve Addiction", , , "Healing", "10 sec.", "1 day", "6", "Neutralize Poison>=slc(12)", G54)
		$$sp("Relieve Madness", , "Spell#", "Healing;Mind Control", "10 sec.", "10 min.", "2", "Lend Health>=slc(12);Wisdom>=slc(12)", G54)
		$$sp("Resist Disease", , , "Healing;Protection and Warning", "10 sec.", "1 hr.", "4/3", "Sterilize>=slc(12)", G54)
		$$sp("Resist Poison", , , "Healing;Protection and Warning", "10 sec.", "1 hr.", "4/3", "Vigor>=slc(12)", G54)
		$$sp("Restore Sight", , , "Healing;*Restore", "5 sec.", "1 hr.", "varies#", "Minor Healing>=slc(12)~Keen Eyes>=slc(12)|Strike Blind>=slc(12)", G55)
		$$sp("Restore Hearing", , , "Healing;*Restore", "5 sec.", "1 hr.", "varies#", "Minor Healing>=slc(12)~Keen Ears>=slc(12)|Strike Deaf>=slc(12)", G55)
		$$sp("Restore Speech", , , "Healing;*Restore", "5 sec.", "1 hr.", "5/3", "Minor Healing>=slc(12)~Great Voice>=slc(12)|Strike Dumb>=slc(12)", G55)
		$$sp("Cure Insanity*", , , "Healing", "1 hr.", "Perm.", "3 per point#", "Major Healing>=slc(12);Relieve Madness>=slc(12);#5,Sp:Mind Control>=slc(12)", G55)
		$$sp("Cure Addiction*", , "Automatic#", "Healing", "1 hr.", "Perm.", "varies#", "Relieve Addiction>=slc(12)", G55)
		$$seespell	Detect Poison	Protection and Warning
		$$seespell	Stop Spasm	Body Control
		end
	sublist "Illusion and Creation" memlist
		$$sp("Inscribe", "Area", "IQ", "Illusion and Creation;Making and Breaking", , , "1/1#", "Simple Illusion>=slc(12);Copy>=slc(12)", G56)
		$$sp("Duplicate*", , , "Illusion and Creation", "sec.=cost", "Indef.#", "3 per 5 lbs.", "Create Object>=slc(12);Copy>=slc(12)", G56)
		$$sp("Phantom*", "Area", , "Illusion and Creation", , , "5/h#", "#1,Adv:Magery>=2;Perfect Illusion>=slc(12);Hinder>=slc(12);Apportation>=slc(12)", G57)
		$$sp("Create Mount", , , "Illusion and Creation;*Create", "3 sec.", "1 hr.", "8/3", "#1,Adv:Magery>=3;Create Animal>=slc(12)", G57)
		$$sp("Initiative", "Area", , "Illusion and Creation", "10 sec.", "varies#", "1/3 per +#", "Independence>=slc(12);Wisdom>=slc(12)", G57)
		end
	sublist "Knowledge" memlist
		$$sp("Tell Position", "Information", , "Knowledge", , "Instant", "1", "Measurement>=slc(12)", G58)
		$$sp("Know Location", "Information", , "Knowledge", "10 sec.", "Instant", "2", "#1,Adv:Magery>=1;Tell Position>=slc(12)", G58)
		$$sp("Test Area", "Area;Information", , "Knowledge", , "Instant", "1#", "Measurement>=slc(12)", G58)
		$$sp("Know True Shape", "Information", , "Knowledge", , "Instant", "2", "#1,Adv:Magery>=1;#1,Sp:*Shifting>=slc(12)~Aura>=slc(12)|Know Illusion>=slc(12)", G58)
		$$sp("Memorize", , , "Knowledge;Mind Control", "2 sec.", "10 sec.#", "3", "Wisdom>=slc(12)|#6,Sp:Knowledge>=slc(12)", G59)
		$$sp("Recall", , , "Knowledge;Mind Control", "10 sec.", "1 day#", "4", "#1,Adv:Magery>=2;Memorize>=slc(12);History>=slc(12)", G59)
		$$sp("Remember Path", , , "Knowledge", "10 sec.", "1 hr.#", "3/1", "Find Direction>=slc(12);Memorize>=slc(12)", G59)
		sublist "Divination" memlist
			$$sp("Divination (Arm Measuring)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#10,Sp:Body Control>=slc(12)|Adv:Blessed", G59)
			$$sp("Divination (Augury)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#5,Sp:Air>=slc(12);#5,Sp:Earth>=slc(12)|Adv:Blessed", G59)
			$$sp("Divination (I Ching)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "Adv:Blessed|History>=slc(12);#2,Sp:Air>=slc(12);#2,Sp:Earth>=slc(12);#2,Sp:Fire>=slc(12);#2,Sp:Water>=slc(12)~Adv:Literacy|Configuration:TL>4-&tl;!Dis:Illiteracy|Adv:Blessed", G60)
			$$sp("Divination (Maize Kernel Reading)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "Adv:Blessed|History>=slc(12)~#10,Sp:Earth>=slc(12)|#10,Sp:Plant>=slc(12)|Adv:Blessed", G60)
			$$sp("Divination (Daybook Reading)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "Adv:Blessed|History>=slc(12);#10,Sp:Knowledge>=slc(12)~Adv:Literacy|Configuration:TL>4-&tl;!Dis:Illiteracy|Adv:Blessed", G60)
			$$sp("Divination (Galactomancy)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "Adv:Blessed|History>=slc(12);#5,Sp:Animal>=slc(12);#5,Sp:Water>=slc(12)", G60)
			$$sp("Divination (Graveweed Summoning)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "Adv:Blessed|History>=slc(12);#2,Sp:Plant>=slc(12);#1,Sp:Air>=slc(12);#1,Sp:Earth>=slc(12);#1,Sp:Fire>=slc(12);#1,Sp:Water>=slc(12);Summon Spirit>=slc(12)", G60)
			$$sp("Divination (Ornithomancy)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#5,Sp:Air>=slc(12);#5,Sp:Animal>=slc(12)|Adv:Blessed", G60)
			$$sp("Divination (Rhabdomancy)", , , "Knowledge;*Divination", "1 hr.#", "Instant", "10", "History>=slc(12);#4,Sp:Earth>=slc(12);#4,Sp:Plant>=slc(12);#4,Sp:Water>=slc(12)|Adv:Blessed", G60)
			$$sp("Divination (Sympathetic Tidings)", , , "Knowledge;*Divination", "10 min.#", "Instant", "3", "History>=slc(12);Sense Danger>=slc(12)|Adv:Blessed", G60)
			end
		$$sp("Seek Magic", "Information", , "Knowledge;Meta-Spell;*Seek", "10 sec.", "Instant", "6", "Detect Magic>=slc(12)", G60)
		$$sp("Astral Vision*", , , "Knowledge;Necromantic", , , "4/2", "Sense Spirit>=slc(12);See Invisible>=slc(12)", G61)
		$$sp("Far-Feeling", , , "Knowledge", "3 sec.", , "3/1", "#1,Adv:Magery>=1", G61)
		$$sp("Projection", , , "Knowledge", "3 sec.", , "4/2", "Sense Spirit>=slc(12);#4,Sp:Knowledge>=slc(12)", G61)
		$$sp("Wizard Mouth", , , "Knowledge;Food;Sound", "2 sec.", , "4/2", "Apportation>=slc(12);Far-Tasting>=slc(12);Great Voice>=slc(12)", G61)
		$$sp("Wizard Nose", , , "Knowledge;Food", "2 sec.", , "3/2", "Apportation>=slc(12);Far-Tasting>=slc(12)", G62)
		$$sp("Wizard Hand", , , "Knowledge;Movement", "3 sec.", , "4/3#", "Manipulate>=slc(12);Far-Feeling>=slc(12)", G62)
		$$sp("Images of the Past", , , "Knowledge;Light and Darkness", "10 sec.", , "3/3#", "#1,Adv:Magery>=2;History>=slc(12);Simple Illusion>=slc(12)", G62)
		$$sp("Echoes of the Past", , , "Knowledge;Sound", "10 sec.", , "2/2#", "#1,Adv:Magery>=2;History>=slc(12);Voices>=slc(12)", G63)
		$$sp("Scents of the Past", , , "Knowledge;Food", "10 sec.", , "1/1#", "#1,Adv:Magery>=2;History>=slc(12);Odor>=slc(12)", G63)
		$$seespell	Know Recipe	Food, Technological
		$$seespell	Metal Vision	Earth
		$$seespell	Plant Vision	Plant
		$$seespell	Plastic Vision	Technological, Metal/Plastic
		$$seespell	Schematic*	Technological
		$$seespell	Small Vision	Light and Darkness
		end
	sublist "Light and Darkness" memlist
		$$sp("Remove Shadow", , "IQ", "Light and Darkness", , , "2/1", "Light>=slc(12)", G63)
		$$sp("Remove Reflection", , "IQ", "Light and Darkness", , , "2/1", "Remove Shadow>=slc(12)", G63)
		$$sp("Shape Light", , , "Light and Darkness", , , "2/2", "Light>=slc(12)", G63)
		$$sp("Glow", "Area", , "Light and Darkness", "sec.=cost#", "2d days#", "varies#", "Continual Light>=slc(12)", G64)
		$$sp("Gloom", "Area", , "Light and Darkness", "sec.=cost#", "2d days#", "varies#", "Continual Light>=slc(12)", G64)
		$$sp("Mage Light", , , "Light and Darkness", , , "1 to 3/s#", "Mage Sight>=slc(12);Light>=slc(12)", G64)
		$$sp("Continual Mage Light", , , "Light and Darkness", , "2d days#", "2 to 6/s#", "Mage Light>=slc(12);Continual Light>=slc(12)", G64)
		$$sp("Sunlight", "Area", , "Light and Darkness", , , "2/1", "#1,Adv:Magery>=1;Glow>=slc(12);Colors>=slc(12)", G64)
		$$sp("Continual Sunlight", "Area", , "Light and Darkness", , "2d days#", "3", "Sunlight>=slc(12)", G64)
		$$sp("Wall of Light", "Area", , "Light and Darkness", , , "1 to 3/s#", "Continual Light>=slc(12)", G64)
		$$sp("Small Vision", , , "Light and Darkness;Knowledge", "2 sec.", , "4/2#", "Keen Eyes>=slc(12)|#5,Sp:Light and Darkness>=slc(12)~!Dis:Blindness;!Dis:Bad Sight", G65)
		$$sp("Bright Vision", , , "Light and Darkness", , , "2/1", "Keen Eyes>=slc(12)|#5,Sp:Light and Darkness>=slc(12)~!Dis:Blindness", G65)
		$$sp("Mirror", , , "Light and Darkness", , , "2 per hex/s", "Colors>=slc(12)", G65)
		$$sp("Sunbolt", "Missile", , "Light and Darkness", "1 to 3 sec.", "Instant", "1 to 3", "Sunlight>=slc(12);#6,Sp:Light and Darkness>=slc(12)", G65)
		$$sp("Body of Shadow*", , "HT", "Light and Darkness;*Shifting", "5 sec.", , "6/3", "#1,Adv:Magery>=2;Shape Darkness>=slc(12)", G65)
		$$seespell	Images of the Past	Knowledge
		$$seespell	Shade	Protection and Warning
		end
	sublist "Making and Breaking" memlist
		$$sp("Explode*", , , "Making and Breaking", , "Instant", "2 to 6", "#1,Adv:Magery>=2;Shatter>=slc(12);Apportation>=slc(12)", G66)
		$$sp("Rive*", , , "Making and Breaking", , "Instant", "1 per 1d#", "#1,Adv:Magery>=2;Shatter>=slc(12)", G66)
		$$sp("Soilproof", , , "Making and Breaking", "2 sec.", "10 min.", "2/1#", "Clean>=slc(12)", G66)
		$$sp("Transparency", , , "Making and Breaking", "10 sec.", , "4/2", "Dye>=slc(12);Stone to Earth>=slc(12)", G67)
		$$sp("Toughen", , , "Making and Breaking", "5 sec.", "1 hr.", "varies#", "Shatterproof>=slc(12)", G67)
		$$sp("Mapmaker", "Special", , "Making and Breaking", "10 sec.", "1 hr.", "4/2", "Inscribe>=slc(12);Measurement>=slc(12)", G67)
		$$sp("Mystic Mark", , "Special", "Making and Breaking", "10 sec.", "Perm.#", "3", "Dye>=slc(12);Trace>=slc(12)", G67)
		$$sp("Fasten", , "DX", "Making and Breaking", , "Perm.", "3#", "Knots>=slc(12)", G67)
		$$sp("Animate Object*", , "Special", "Making and Breaking", "3 sec.", , "1 per 5 lbs./s#", "#1,Adv:Magery>=2;#3,Sp:*Shape>=slc(12)", G67)
		$$sp("Weapon Self*", , "HT#", "Making and Breaking", "5 sec.", , "8/4", "#1,Adv:Magery>=2;Apportation>=slc(12);Reshape>=slc(12);#6,Sp:Making and Breaking>=slc(12)", G68)
		$$sp("Transform Object*", , "Special", "Making and Breaking", "sec.=cost", "1 hr.", "1 per lb./s#", "#1,Adv:Magery>=2;Reshape>=slc(12);#4,Sp:*Create>=slc(12)", G68)
		$$sp("Contract Object*", , , "Making and Breaking", "3 sec.", "1 hr.", "1 per lb./s#", "#1,Adv:Magery>=3;Transform Object>=slc(12)", G68)
		$$sp("Shrink Object*", , , "Making and Breaking", "3 sec.", "1 hr.", "1 per lb./s#", "Contract Object>=slc(12)", G68)
		$$sp("Extend Object*", , , "Making and Breaking", "3 sec.", "1 hr.", "1 per lb./s#", "#1,Adv:Magery>=3;Transform Object>=slc(12)", G68)
		$$sp("Enlarge Object*", , , "Making and Breaking", "3 sec.", "1 hr.", "1 per lb./s#", "Extend Object>=slc(12)", G69)
		$$seespell	Inscribe	Illusion and Creation
		$$seespell	Rebuild*	Technological, Machine
		end
	sublist "Meta-Spell" memlist
		$$sp("False Aura", "Regular;Area", "IQ", "Meta-Spell", "10 sec.", "10 hrs.", "4/2#", "Conceal Magic>=slc(12);Aura>=slc(12)", G69)
		$$sp("Remove Aura", , "IQ", "Meta-Spell", "10 sec.", "Perm.#", "5", "Dispel Magic>=slc(12);Aura>=slc(12)", G69)
		$$sp("Spell Wall", , , "Meta-Spell", , , "2 per hex/s", "Spell Shield>=slc(12)", G69)
		$$sp("Suspend Spell", , "Spell", "Meta-Spell", , , "1/10 spell cost/s#", "#1,Adv:Magery>=1", G70)
		$$sp("Suspend Magic", "Area", "Spell", "Meta-Spell", "sec.=cost", , "3/2", "Suspend Spell>=slc(12);#8,Spells>=slc(12)", G70)
		$$sp("Displace Spell", , "Spell", "Meta-Spell", "5 sec.", "Indef.#", "1/4 spell cost#", "Suspend Magic>=slc(12)", G70)
		$$sp("Spellguard*", , , "Meta-Spell", "sec.=cost", "10 hrs.", "1 to 3/s#", "Dispel Magic>=slc(12)", G71)
		$$sp("Catch Spell*", "Blocking", , "Meta-Spell", "none", "Instant", "3", "#1,Adv:Magery>=2;Main:DX>=12;Return Missile>=slc(12)", G71)
		$$sp("Throw Spell*", "Missile", "Special", "Meta-Spell", , "Indef.#", "3", "Delay>=slc(12);Catch Spell>=slc(12)", G71)
		$$sp("Hang Spell*", "Special", , "Meta-Spell", "10 sec.", "1 hr.", "spell cost/s#", "Delay>=slc(12)", G71)
		$$sp("Maintain Spell*", "Special", , "Meta-Spell", "2 sec.#", "Indef.#", "spell cost#", "Link>=slc(12)", G72)
		$$sp("Lend Spell", , , "Meta-Spell", "3 sec.", "Perm.", "spell cost#", "#1,Adv:Magery>=1;Lend Skill>=slc(12);#1,6,Spells>=slc(12)", G72)
		$$sp("Steal Spell*", , "Spell", "Meta-Spell", "5 sec.", "Perm.", "spell cost#", "Lend Spell>=slc(12);Great Ward>=slc(12)", G73)
		$$sp("Suspend Magery*", , "IQ+Magery", "Meta-Spell", "10 sec.", "1 hr.", "12/12#", "#1,Adv:Magery>=2;#2,10,Spells>=slc(12)", G73)
		$$sp("Drain Magery*", , "IQ+Magery", "Meta-Spell", "10 min.", "Perm.", "30", "#1,Adv:Magery>=3;Suspend Magery>=slc(12)", G73)
		$$sp("Telecast*", "Special", , "Meta-Spell", "1 min.", , "varies#", "#1,Adv:Magery>=3;Teleport>=slc(12);Wizard Eye>=slc(12);#1,10,Spells>=slc(12)", G73)
		$$sp("Suspend Curse", , "Spell", "Meta-Spell", "1 min.", "10 min.", "10/10", "#1,Adv:Magery>=1;#1,12,Spells>=slc(12)", G74)
		$$sp("Suspend Mana*", "Area", , "Meta-Spell", "10 min.", "varies#", "5", "Suspend Magic>=slc(12);#1,10,Spells>=slc(12)", G74)
		$$sp("Charge Powerstone*", , , "Meta-Spell", "10 min.", "Indef.", "3 per point", "#1,Adv:Magery>=3;Powerstone>=slc(12);Lend Strength>=slc(12)", G74)
		$$sp("Scryfool", , "Special", "Meta-Spell", "10 sec.", "10 hrs.", "4/2", "#1,Adv:Magery>=2;Sense Observation>=slc(12);Simple Illusion>=slc(12)", G74)
		$$seespell	Seek Magic	Knowledge, Seek
		end
	sublist "Mind Control" memlist
		$$sp("Weaken Will", , "IQ", "Mind Control", , , "2 per point/h#", "#1,Adv:Magery>=1;Foolishness>=slc(12)", G75)
		$$sp("Strengthen Will", , , "Mind Control", , , "1 per +/h#", "#1,Adv:Magery>=1;#6,Sp:Mind Control>=slc(12)", G75)
		$$sp("Disorient", "Area", "IQ", "Mind Control", "10 sec.", "varies#", "1", "Foolishness>=slc(12)", G75)
		$$sp("Fascinate", "Regular or Blocking", "IQ", "Mind Control", , "Indef.", "4/none", "Daze>=slc(12)", G75)
		$$sp("Enthrall", "Special", "IQ", "Mind Control", , "1 hr.#", "3/3", "Forgetfulness>=slc(12);Daze>=slc(12);Slow>=slc(12)", G75)
		$$sp("Glib Tongue", , "IQ", "Mind Control", , "5 min.", "2/1", "Suggestion>=slc(12)", G75)
		$$sp("Vigil*", , , "Mind Control", , "1 night", "8", "#1,Adv:Magery>=2;Sleep>=slc(12);Lend Strength>=slc(12)", G75)
		$$sp("Lure", "Area", "IQ", "Mind Control", "10 sec.", "1 hr.", "2/2", "Emotion Control>=slc(12)", G76)
		$$sp("Compel Lie", , "IQ", "Mind Control;Communication and Empathy", , "5 min.", "4/2", "Emotion Control>=slc(12)", G76)
		$$sp("Ecstasy*", , "IQ", "Mind Control", "3 sec.", "10 sec.", "6", "#1,Adv:Magery>=2;Emotion Control>=slc(12)", G76)
		$$sp("Hallucination", , "IQ", "Mind Control", "3 sec.", , "4/2", "Madness>=slc(12);Suggestion>=slc(12)", G76)
		$$sp("Great Hallucination*", , "IQ", "Mind Control", "4 sec.", , "6/3", "#1,Adv:Magery>=2;Hallucination>=slc(12)", G76)
		$$sp("Command", "Blocking", "IQ", "Mind Control", "none", "Instant", "2", "#1,Adv:Magery>=2;Forgetfulness>=slc(12)", G77)
		$$sp("Oath", , "Special", "Mind Control", "1 min.", "Perm.", "4", "#1,Adv:Magery>=1;Emotion Control>=slc(12)", G77)
		$$sp("Will Lock", "Area", "(ST+IQ)/2", "Mind Control", "varies#", "1 day", "3", "Emotion Control>=slc(12)", G77)
		$$sp("Dull Eyes", , "HT", "Mind Control;*Dull", , "30 min.", "1 to 3/h#", , G77)
		$$sp("Dull Ears", , "HT", "Mind Control;*Dull", , "30 min.", "1 to 3/h#", , G77)
		$$sp("Dull Nose", , "HT", "Mind Control;*Dull", , "30 min.", "1 to 3/h#", , G77)
		$$sp("Dullness*", , "HT", "Mind Control", , "10 min.", "2 to 10/h#", "#2,Sp:*Dull>=slc(12)", G77)
		$$sp("Encrypt", , "Special", "Mind Control", , "1 week#", "1 per 10 hexes#", "Daze>=slc(12)", G78)
		$$seespell	Memorize	Knowledge
		$$seespell	Recall	Knowledge
		$$seespell	Relieve Madness	Healing
		end
	sublist "Movement" memlist
		$$sp("Slow", , "HT", "Movement", "3 sec.", "10 sec.", "5/4", "#1,Adv:Magery>=1;Haste>=slc(12);Hinder>=slc(12)", G78)
		$$sp("Hold Fast", "Blocking", , "Movement", "none", "Instant", "1 per hex", "Apportation>=slc(12)", G78)
		$$sp("Long March", , "ST", "Movement", "1 min.", "1 day", "3", "#1,Adv:Magery>=1~Clumsiness>=slc(12)|Fatigue>=slc(12)", G78)
		$$sp("Light Tread", , , "Movement", , "10 min.", "4/1#", "Apportation>=slc(12);Shape Earth>=slc(12)", G78)
		$$sp("Grease", "Area", , "Movement", , "10 min.", "3/3", "Haste>=slc(12)", G79)
		$$sp("Jump", , , "Movement", , , "1 to 3#", "Apportation>=slc(12)", G79)
		$$sp("Increase Burden", , "Special", "Movement", "3 sec.", "10 min.", "varies#", "Apportation>=slc(12)", G79)
		$$sp("Slide", , "IQ", "Movement", , , "2/2", "Apportation>=slc(12);Grease>=slc(12)", G79)
		$$sp("Freedom", , , "Movement;Protection and Warning", , , "2 per +/s#", "#3,Sp:Body Control>=slc(12);#3,Sp:Movement>=slc(12);#3,Sp:Protection and Warning>=slc(12)", G79)
		$$sp("Pull", , , "Movement", "5 sec.", , "1 per 2 ST/s#", "#1,Adv:Magery>=2;Levitation>=slc(12);#4,Sp:Movement>=slc(12)", G80)
		$$sp("Repel", , , "Movement", "5 sec.", , "1 per 2 ST/s#", "#1,Adv:Magery>=2;Levitation>=slc(12);#4,Sp:Movement>=slc(12)", G80)
		$$sp("Flying Carpet*", , , "Movement", "5 sec.", "10 min.", "varies#", "Flight>=slc(12)|#1,Adv:Magery>=2;Walk on Air>=slc(12)", G80)
		$$sp("Blink Other*", "Blocking", , "Movement;Gate", "none", "Instant", "2", "Blink>=slc(12)", G81)
		$$sp("Cloud-Walking", , , "Movement;Air;Water;Weather", , "1 hr.", "3/2", "Walk on Air>=slc(12);Walk on Water>=slc(12)", G81)
		$$sp("Cloud-Vaulting*", , , "Movement;Weather;Air;Water", , "1 sec./100 mi.", "7", "#1,Adv:Magery>=2;Jump>=slc(12);Cloud-Walking>=slc(12)", G81)
		$$sp("Distant Blow", , , "Movement", "3 sec.", "5 sec.", "3/3", "#1,Adv:Magery>=2;Apportation>=slc(12)", G81)
		$$seespell	Air Vortex	Air
		$$seespell	Beacon	Gate
		$$seespell	Divert Teleport*	Gate
		$$seespell	Trace Teleport	Gate
		$$seespell	Rapid Journey*	Gate
		$$seespell	Wizard Hand	Knowledge
		end
	sublist "Necromantic" memlist
		$$sp("Zombie Summoning", "Special", , "Necromantic", "4 sec.", , "5/2#", "Zombie>=slc(12)", G84)
		$$sp("Slow Healing", , "HT", "Necromantic", "10 sec.", "1 day", "1 to 5/s#", "#1,Adv:Magery>=1;Frailty>=slc(12);Steal Health>=slc(12)", G84)
		$$sp("Stop Healing", , , "Necromantic", "10 sec.", "varies#", "10", "Slow Healing>=slc(12)", G84)
		$$sp("Turn Spirit", , "IQ", "Necromantic", , "10 sec.", "4/2", "Fear>=slc(12);Sense Spirit>=slc(12)", G84)
		$$sp("Repel Spirits", "Area", "IQ", "Necromantic", "10 sec.", "1 hr.", "4/2", "Banish>=slc(12);Turn Spirit>=slc(12)", G85)
		$$sp("Astral Block", "Area", , "Necromantic", "2 sec.", "10 min.", "4/2#", "Summon Spirit>=slc(12);Repel Spirits>=slc(12)", G85)
		$$sp("Steal Beauty*", , , "Necromantic;*Shifting", "30 sec.", "1 day#", "1 per point diff./h#", "#1,Adv:Magery>=3;Alter Visage>=slc(12);Steal Health>=slc(12)", G85)
		$$sp("Steal Skill*", , "IQ", "Necromantic", "1 min.", "1 day#", "1 per point stolen#", "#1,Adv:Magery>=3;Borrow Skill>=slc(12);Daze>=slc(12)", G86)
		$$sp("Steal Might*", , "ST", "Necromantic", "1 min.", "1 day#", "1 per point stolen#", "#1,Adv:Magery>=3;Steal Strength>=slc(12);Fatigue>=slc(12)", G86)
		$$sp("Steal Dexterity*", , "DX", "Necromantic", "1 min.", "1 day#", "1 per point stolen#", "#1,Adv:Magery>=3;Steal Health>=slc(12);Clumsiness>=slc(12)", G86)
		$$sp("Steal Wisdom*", , "IQ", "Necromantic", "1 min.", "1 day#", "1 per point stolen#", "#1,Adv:Magery>=3;Steal Health>=slc(12);Foolishness>=slc(12)", G86)
		$$sp("Steal Vigor*", , "HT", "Necromantic", "1 min.", "1 day#", "1 per point stolen#", "#1,Adv:Magery>=3;Steal Health>=slc(12);Frailty>=slc(12)", G86)
		$$sp("Rotting Death*", , "HT", "Necromantic", "3 sec.", "1 sec.", "3/2", "#1,Adv:Magery>=2;Sickness>=slc(12);Pestilence>=slc(12)", G86)
		$$sp("Evisceration*", , "HT or IQ", "Necromantic", "5 sec.", "varies#", "10", "#1,Adv:Magery>=3;Apportation>=slc(12);Steal Health>=slc(12)", G86)
		$$sp("Summon Minor Demons", "Special", , "Necromantic;Gate", "2 min.", "1 hr.", "15", "#1,Adv:Magery>=1;#1,10,Spells>=slc(12)", G87)
		$$sp("Materialize", "Special", "ST or IQ", "Necromantic", , , "5/5", "Summon Spirit>=slc(12)", G87)
		$$sp("Solidify", "Special", "ST or IQ", "Necromantic", , , "50/10", "Materialize>=slc(12)", G87)
		$$sp("Animate Shadow", , "HT", "Necromantic", "2 sec.", "10 sec.", "4/4", "Skull-Spirit>=slc(12);Shape Darkness>=slc(12)", G87)
		$$seespell	Astral Vision*	Knowledge
		$$seespell	Burning Death*	Fire
		$$seespell	Strike Barren	Body Control
		end
	sublist "Plant" memlist
		$$sp("Plant Vision", , , "Plant;Knowledge", , "30 sec.", "1 per 10 hexes/s#", "Shape Plant>=slc(12)", G88, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Pollen Cloud", "Area", "HT", "Plant", , "5 min.#", "1", "Shape Plant>=slc(12)", G88, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Rain of Nuts", "Area", , "Plant", , , "1/s", "#1,Adv:Magery>=1;Shape Plant>=slc(12);#6,Sp:Plant>=slc(12)", G88, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Blight", "Area", , "Plant", "5 min.", "varies#", "1#", "Plant Growth>=slc(12)", G88, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Rejuvenate Plant", , , "Plant", , "Perm.", "3 per hex", "#1,Adv:Magery>=1;Plant Growth>=slc(12)", G88, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("False Tracks", , "IQ", "Plant", , , "2/1", "Shape Plant>=slc(12);Shape Earth>=slc(12)", G88, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Conceal", "Area", , "Plant", "4 sec.", "1 hr.", "varies#", "Plant Growth>=slc(12)", G89, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Walk Through Plants", , , "Plant", , , "3/1", "Hide Path>=slc(12);Shape Plant>=slc(12)", G89, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Walk Through Wood", , , "Plant", , "1 sec.", "3/2", "Walk Through Plants>=slc(12)", G89, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Plant Speech", , , "Plant", , , "3/2", "#1,Adv:Magery>=1;Plant Sense>=slc(12)", G89, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Plant Control", , "IQ", "Plant", , , "3/h", "Plant Sense>=slc(12)", G89, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Body of Wood", , "HT", "Plant;*Shifting", "5 sec.", , "7/3", "#1,Adv:Magery>=2;Plant Form>=slc(12)", G89, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Body of Algae", , "HT", "Plant;*Shifting", "5 sec.", , "6/2", "#1,Adv:Magery>=2;Plant Form>=slc(12);Shape Water>=slc(12)", G90, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Plant Form Other*", "Special", "IQ", "Plant;*Shifting", "30 sec.", "1 hr.", "5/2", "#1,Adv:Magery>=2;Plant Form>=slc(12)", G90, "TreeKin?hsp(~x,iq):vhsp(~x,iq)")
		$$sp("Immurement", , "HT", "Plant", "3 sec.", "Indef.#", "8", "#1,Adv:Magery>=2;Walk Through Wood>=slc(12)", G90, "TreeKin?asp(~x,iq):hsp(~x,iq)")
		$$seespell	Purify Earth	Earth
		end
	sublist "Protection and Warning" memlist
		$$sp("Detect Poison", "Area;Information", , "Protection and Warning;Healing", "2 sec.", "Instant", "2", "Sense Danger>=slc(12);Test Food>=slc(12)", G91)
		$$sp("Block", "Blocking", , "Protection and Warning", "none", "Instant", "1 per point PD#", "#1,Adv:Magery>=1", G91)
		$$sp("Hardiness", "Blocking", , "Protection and Warning", "none", "Instant", "1 per point DR#", "Stiffen>=slc(12)", G91)
		$$sp("Turn Blade", "Blocking", "DX", "Protection and Warning", "none", "Instant", "1", "Apportation>=slc(12)|Spasm>=slc(12)", G91)
		$$sp("Bladeturning", , "Special", "Protection and Warning", , , "2/2", "Shield>=slc(12)|Turn Blade>=slc(12)", G91)
		$$sp("Deflect Missile", "Blocking", , "Protection and Warning", "none", "Instant", "1", "Apportation>=slc(12)", G91)
		$$sp("Catch Missile", "Blocking", , "Protection and Warning", "none", "Instant", "2", "Deflect Missile>=slc(12)", G92)
		$$sp("Return Missile", "Blocking", , "Protection and Warning", "none", "Instant", "3", "Catch Missile>=slc(12)", G92)
		$$sp("Reflect Gaze*", "Blocking", , "Protection and Warning", "none", "Instant", "2", "Mirror>=slc(12)", G92)
		$$sp("Sense Observation", "Area", , "Protection and Warning", "5 sec.", "1 hr.", "1/h#", "Sense Danger>=slc(12)|Scryguard>=slc(12)", G92)
		$$sp("Shade", , , "Protection and Warning;Light and Darkness", "10 sec.", "1 hr.", "1/h", "Continual Light>=slc(12)|Shield>=slc(12)", G92)
		$$sp("Force Wall", , , "Protection and Warning", , "10 min.", "2 per hex/s", "Force Dome>=slc(12)", G92)
		$$sp("Utter Wall", , , "Protection and Warning", , , "4 per hex/s", "Utter Dome>=slc(12);Spell Wall>=slc(12)", G93)
		$$seespell	Coolness	Water, Ice
		$$seespell	Freedom	Movement
		$$seespell	Resist Disease	Healing
		$$seespell	Resist Lightning	Air, Electricity
		$$seespell	Resist Poison	Healing
		$$seespell	Resist Sound	Sound
		$$seespell	Resist Water	Water
		$$seespell	Resist Acid	Water, Acid
		end
	sublist "Sound" memlist
		$$sp("Imitate Voice", , "HT", "Sound", , "1 min.", "3/1", "Voices>=slc(12)", G93)
		$$sp("Resist Sound", , , "Sound;Protection and Warning", , "1 min.", "2 per hex/h", "#4,Sp:Sound>=slc(12)", G93)
		$$sp("Garble", , "IQ", "Sound", , "1 min.", "4/2", "Voices>=slc(12)", G93)
		$$sp("Converse", , "Spell", "Sound", , "Indef.#", "2", "#1,Adv:Magery>=1;Garble>=slc(12);Silence>=slc(12)", G93)
		$$sp("Silver Tongue", , , "Sound", , , "3/2", "Voices>=slc(12);Emotion Control>=slc(12)", G93)
		$$sp("Message", , "Spell", "Sound", "varies#", "varies#", "1 per 15 sec.", "Great Voice>=slc(12);Seeker>=slc(12)", G94)
		$$sp("Musical Scribe", , , "Sound", , , "3/1#", "Scribe>=slc(12)", G94)
		$$seespell	Alter Voice	Body Control
		$$seespell	Concussion	Air
		$$seespell	Echoes of the Past	Knowledge
		$$seespell	Wizard Mouth	Knowledge, Food
		end
	sublist Technological memlist
		$$seespell	Know Recipe	Food, Knowledge
		sublist "Machine" memlist
			$$sp("Seek Machine/TL", Information, , "Technological;*Machine;*Seek", "10 sec.", "Instant", 3, , G95)
			$$sp("Reveal Function/TL", Information, spell, Technological;*Machine, 10 min., Instant, 8, "Seek Machine>=slc(12)", G96)
			$$sp(Machine Control/TL, Regular, , "Technological;*Machine;*Animal Control", , 1 min., 6/3, "Reveal Function>=slc(12);Locksmith>=slc(12);Lightning>=slc(12)", G96)
			$$sp(Machine Summoning/TL, Regular, , Technological;*Machine, 4 sec., 1 min., 4/2, "Machine Control>=slc(12)", G96)
			$$sp(Machine Speech/TL, Regular, , Technological;*Machine;Communication and Empathy, , 1 min., 5/3, "Machine Summoning>=slc(12)", G96)
			$$sp(Glitch/TL, Regular, HT, Technological;*Machine, , Instant, 3, "Machine Control>=slc(12)", G96)
			$$sp(Malfunction/TL, Regular, HT, Technological;*Machine, , 1 min., 5, "#1,Adv:Magery>=2;Glitch>=slc(12)", G97)
			$$sp(Schematic/TL*, Information, , Technological;*Machine;Knowledge, 30 sec., 1 min., "5/h#", "Reveal Function>=slc(12);History>=slc(12)", G97)
			$$sp(Rebuild/TL*, Regular, , Technological;*Machine;Making and Breaking, sec.=cost, Perm., "30/500 lbs.#", "#1,Adv:Magery>=3;Repair>=slc(12);Create Object>=slc(12);#3,Sp:Air>=slc(12);#3,Sp:Earth>=slc(12);#3,Sp:Fire>=slc(12);#3,Sp:Water>=slc(12)", G97)
			$$sp("Animate Machine/TL*", Regular, IQ, Technological;*Machine, sec.=cost, 1 min., "varies#", "Machine Control>=slc(12)~Animation>=slc(12)|Animate Object>=slc(12)", G98)
			$$sp("Machine Possession/TL", Regular, IQ, Technological;*Machine, 30 sec., 1 min., 6/2, "Machine Control>=slc(12)~Rider Within>=slc(12)|Soul Rider>=slc(12)", G98)
			$$sp("Permanent Machine Possession/TL*", Regular, IQ, Technological;*Machine, 5 min., Indef., 30, "#1,Adv:Magery>=3;Machine Possession>=slc(12)", G98)
			$$sp("Awaken Computer/TL*", Regular, , Technological;*Machine, 10 sec., 1 hr., "varies#", "Animation>=slc(12);Wisdom>=slc(12)", G99)
			end
		sublist "Energy" memlist
			$$sp("Seek Power/TL", Information, , Technological;*Energy;*Seek, 10 sec., Instant, 3, , G99)
			$$sp("Seek Fuel/TL", Information, , Technological;*Energy;*Seek, 10 sec., Instant, 3, , G99)
			$$sp("Test Fuel/TL", Information, , Technological;*Energy, , Instant, "varies#", , G99)
			$$sp("Preserve Fuel/TL", , , Technological;*Energy, , 1 week, "4 per lb./h", "Test Fuel>=slc(12)", G100)
			$$sp("Purify Fuel/TL", , , Technological;*Energy, , Perm., "1/2 per lb.#", "Purify Water>=slc(12)|Decay>=slc(12)", G100)
			$$sp("Create Fuel/TL", , , "Technological;*Energy;*Create", 30 sec., Perm., "1 per lb.", "Seek Fuel>=slc(12);#2,Sp:*Transmutation>=slc(12)", G100)
			$$sp("Water to Fuel/TL", , , "Technological;*Energy;*Transmutation", 10 sec., Perm., "8 per gal.", "Purify Fuel>=slc(12);#2,Sp:*Transmutation>=slc(12)", G100)
			$$sp("Stop Power", "Area", , "Technological;*Energy", "3 sec.", "1 min.", "3/h", "#1,Adv:Magery>=1;Seek Power>=slc(12)", G100)
			$$sp("Lend Power/TL", , , "Technological;*Energy", "1 sec.", "Indef.", "varies#", "#1,Adv:Magery>=2;Seek Power>=slc(12)", G100)
			$$sp("Propel/TL", , , "Technological;*Energy", , "Indef.", "varies#", "Create Fuel>=slc(12);Air-Golem>=slc(12)", G101)
			$$sp("Conduct Power/TL*", "Special", , "Technological;*Energy", , "1 min.", "0/1#", "#1,Adv:Magery>=1;Seek Power>=slc(12)", G101)
			$$sp("Steal Power/TL*", , , "Technological;*Energy", "2 sec./point", "varies#", "0", "#1,Adv:Magery>=2;Minor Healing>=slc(12);Conduct Power>=slc(12)", G101)
			$$sp("Draw Power/TL*", , , "Technological;*Energy", , "1 min.", "0/1#", "Steal Power>=slc(12);#2,10,Spells>=slc(12)", G101)
			$$sp("Magnetic Vision", , , "Technological;*Energy", , "1 min.", "2/1", "Keen Eyes>=slc(12)", G102)
			$$sp("Radio Hearing", , , "Technological;*Energy", , "1 min.", "2/1", "Keen Ears>=slc(12)", G102)
			$$sp("Spectrum Vision*", , , "Technological;*Energy", , "1 min.", "4/4", "Infravision>=slc(12)", G102)
			end
		sublist "Radiation" memlist
			$$sp("See Radiation", , , "Technological;*Radiation", , , "3/2", , G104)
			$$sp("Seek Radiation", "Information", , "Technological;*Radiation;*Seek", "10 sec.", "Instant", "3", "See Radiation>=slc(12)", G104)
			$$sp("Irradiate", "Area", , "Technological;*Radiation", , "1 hr.", "1 per 10 rads/hr./h", "Create Earth>=slc(12);Create Fire>=slc(12)", G105)
			$$sp("Extinguish Radiation*", , , "Technological;*Radiation", , "Perm.", "1 per 10 rads/hr./hex", "#1,Adv:Magery>=2;Extinguish Fire>=slc(12);Earth to Air>=slc(12);Irradiate>=slc(12)", G105)
			$$sp("Resist Radiation", , , "Technological;*Radiation", , , "varies#", "#3,Sp:*Radiation>=slc(12)", G105)
			$$sp("Cure Radiation*", , , "Technological;*Radiation", "30 sec.", "Perm.", "1 per 10 rads#", "Resist Radiation>=slc(12);Major Healing>=slc(12)", G105)
			$$sp("Radiation Jet", , , "Technological;*Radiation", , "1 sec.", "1 to 3/s#", "Irradiate>=slc(12);Resist Radiation>=slc(12)", G105)
			$$sp("Breathe Radiation*", , , "Technological;*Radiation", "2 sec.", "1 sec.", "1 to 4", "#1,Adv:Magery>=2;Radiation Jet>=slc(12)", G105)
			end
		sublist "Metal/Plastic" memlist
			$$sp("Seek Metal", "Information", , "Technological;*Metal/Plastic;*Seek", "10 sec.", "Instant", "3", , G105)
			$$sp("Seek Plastic", "Information", , "Technological;*Metal/Plastic;*Seek", "10 sec.", "Instant", "3", , G105)
			$$sp("Identify Metal", "Information", , "Technological;*Metal/Plastic", , "Instant", 1, "Seek Metal>=slc(12)", G106)
			$$sp("Identify Plastic", "Information", , "Technological;*Metal/Plastic", , "Instant", 1, "Seek Plastic>=slc(12)", G106)
			$$sp("Shape Metal", "Regular", "Special", "Technological;*Metal/Plastic;*Shape", , , "6 per hex/h#", "#1,Adv:Magery>=1~Shape Stone>=slc(12)|#6,Sp:Technological>=slc(12)", G106)
			$$sp("Shape Plastic", "Regular", , "Technological;*Metal/Plastic;*Shape", , , "6 per hex/h", "#1,Adv:Magery>=1~Shape Plant>=slc(12)|#6,Sp:Technological>=slc(12)", G106)
			$$sp("Metal Vision", , , "Technological;*Metal/Plastic;Knowledge", , "30 sec.", "2 per 5 hexes/s#", "Shape Metal>=slc(12)", G106)
			$$sp("Plastic Vision", , , "Technological;*Metal/Plastic;Knowledge", , "30 sec.", "2 per 5 hexes/s#", "Shape Plastic>=slc(12)", G106)
			$$sp("Body of Metal*", , "HT", "Technological;*Metal/Plastic;*Shifting", "5 sec.", "1 min.#", "12/6", "#1,Adv:Magery>=2;Shape Metal>=slc(12)", G106)
			end
		end
	sublist Water memlist 
		sublist Weather memlist 
			$$seespell	Cloud-Walking	Movement, Air, Water
			$$seespell	Cloud-Vaulting*	Movement, Air, Water
			$$seespell	Storm	Air, Water
			end 
		$$seespell	Breathe Water	Air
		$$seespell	Earth to Water	Earth
		$$seespell	Mud Jet	Earth
		$$seespell	Swim	Movement
		end 
	
	end



options
	list "Skills"
		begin text "InherentFlight" 1
			end
		end
	end
end
